<?php

/*
 * This file is part of the "laravel-lang/publisher" project.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * @author Andrey Helldar <helldar@ai-rus.com>
 *
 * @copyright 2021 Andrey Helldar
 *
 * @license MIT
 *
 * @see https://github.com/Laravel-Lang/publisher
 */

declare(strict_types=1);

namespace LaravelLang\Publisher\Constants;

/**
 * Based on ISO 15897.
 *
 * @see https://laravel.com/docs/localization#introduction
 *
 * Unicode standard (Intl)
 * @see https://icu4c-demos.unicode.org/icu-bin/locexp
 *
 * ISO-639-1 standard
 * @see https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes
 */
class Locales
{
    public const AFRIKAANS = 'af';

    public const ALBANIAN = 'sq';

    public const ARABIC = 'ar';

    public const ARMENIAN = 'hy';

    public const AZERBAIJANI = 'az';

    public const BASQUE = 'eu';

    public const BELARUSIAN = 'be';

    public const BENGALI = 'bn';

    public const BOSNIAN = 'bs';

    public const BULGARIAN = 'bg';

    public const CATALAN = 'ca';

    public const CENTRAL_KHMER = 'km';

    public const CHINESE = 'zh_CN';

    public const CHINESE_HONG_KONG = 'zh_HK';

    public const CHINESE_T = 'zh_TW';

    public const CROATIAN = 'hr';

    public const CZECH = 'cs';

    public const DANISH = 'da';

    public const DUTCH = 'nl';

    public const ENGLISH = 'en';

    public const ESTONIAN = 'et';

    public const FINNISH = 'fi';

    public const FRENCH = 'fr';

    public const GALICIAN = 'gl';

    public const GEORGIAN = 'ka';

    public const GERMAN = 'de';

    public const GERMAN_SWITZERLAND = 'de_CH';

    public const GREEK = 'el';

    public const GUJARATI = 'gu';

    public const HEBREW = 'he';

    public const HINDI = 'hi';

    public const HUNGARIAN = 'hu';

    public const ICELANDIC = 'is';

    public const INDONESIAN = 'id';

    public const ITALIAN = 'it';

    public const JAPANESE = 'ja';

    public const KANNADA = 'kn';

    public const KAZAKH = 'kk';

    public const KOREAN = 'ko';

    public const LATVIAN = 'lv';

    public const LITHUANIAN = 'lt';

    public const MACEDONIAN = 'mk';

    public const MALAY = 'ms';

    public const MARATHI = 'mr';

    public const MONGOLIAN = 'mn';

    public const NEPALI = 'ne';

    public const NORWEGIAN_BOKMAL = 'nb';

    public const NORWEGIAN_NYNORSK = 'nn';

    public const OCCITAN = 'oc';

    public const PASHTO = 'ps';

    public const PERSIAN = 'fa';

    public const PILIPINO = 'fil';

    public const POLISH = 'pl';

    public const PORTUGUESE = 'pt';

    public const PORTUGUESE_BRAZIL = 'pt_BR';

    public const ROMANIAN = 'ro';

    public const RUSSIAN = 'ru';

    public const SARDINIAN = 'sc';

    public const SERBIAN_CYRILLIC = 'sr_Cyrl';

    public const SERBIAN_LATIN = 'sr_Latn';

    public const SERBIAN_MONTENEGRIN = 'sr_Latn_ME';

    public const SINHALA = 'si';

    public const SLOVAK = 'sk';

    public const SLOVENIAN = 'sl';

    public const SPANISH = 'es';

    public const SWAHILI = 'sw';

    public const SWEDISH = 'sv';

    public const TAGALOG = 'tl';

    public const TAJIK = 'tg';

    public const THAI = 'th';

    public const TURKISH = 'tr';

    public const TURKMEN = 'tk';

    public const UIGHUR = 'ug';

    public const UKRAINIAN = 'uk';

    public const URDU = 'ur';

    public const UZBEK_CYRILLIC = 'uz_Cyrl';

    public const UZBEK_LATIN = 'uz_Latn';

    public const VIETNAMESE = 'vi';

    public const WELSH = 'cy';
}
